CardGame
========

By Pierre Sarrazin (<http://sarrazip.com/>).

This library is in the public domain.

It is a C library that offers a PMODE 4 game library that can display
playing cards. It targets the Tandy Color Computer but should also work
on the Dragon. Most of the features should also work on CoCo-based
versions of OS-9.


# OS-9 Support

OS-9 was suspended with version 0.1.11 but has been restored with version 0.1.12.

Note that the sound features of this version of the library are not supported under OS-9.

To compile with OS-9, pass TARGET=os9 to make.

The "cardgame" demo program MUST be run from a 32x16 VDG terminal.
Use the Clear key to find one.
If none exists, create one with the "shell i=/v1" command, then use Clear to find it.

The "os9timer" demo program can be run from any terminal.

There is no "beep" demo program for OS-9.


# Adapting to version 0.1.11

openPMode4GameScreenMode() and closePMode4GameScreenMode() have been renamed to
openPMode4Game() and closePMode4Game() because the latter does not restore
the screen mode anymore. It cannot know in which mode the screen was initially.

openPMode4Game() does not call resetPalette() anymore, which assumed that Basic
was present. That call was made only when TRUE was passed for emulatePMode4OnCoCo3.
Now, in this case, only palette slots 0..3 are initialized.

openCardGameScreenMode() and closeCardGameScreenMode() have been renamed to
openCardGame() and closeCardGame() for similar reasons.

restoreOriginalTextMode() has been removed from the interface, since it relied
on Basic. The program must restore the text mode itself, if needed.

Under OS-9, this can be done this way:

    putstr("\x12\x0E", 2);

Under the native environment:

    screen(0, 0);

Function waitForKeyWithAnimatedCursor() and readLineFromKeyboard() must now
be passed a callback to a function that returns a timer value that increments
60 times per second. See pmode4game.h for details.


# Version history

    0.1.0  - 2015-08-12 - First public release.
    0.1.1  - 2016-03-12 - New #defines. New function drawFaceDownCard().
    0.1.2  - 2016-03-25 - setConsoleOutHook() and resetConsoleOutHook() now taken
                          from <coco.h>.
    0.1.3  - 2017-12-01 - openCardGameScreenMode() now optionally emulates PMODE 4
                          in a CoCo 3 mode to approximate the artifact colors.
                          Assumes RGB mode. Adapted to compile in linker mode.
    0.1.4  - 2018-04-03 - Adaptation to CMOC 0.1.51 (const).
    0.1.5  - 2018-08-04 - Added square brackets and backslash to 8-bit-wide-font.c.
                          Added sound routines.
    0.1.6  - 2018-09-20 - Adapted to CMOC 0.1.53.
                          Sound functions now declared by cardgame.h. beep.h now obsolete.
    0.1.7  - 2018-10-04 - Fixed openPMode4GameScreenMode() re: CoCo 3 mode.
    0.1.8  - 2018-11-25 - Now compilable for the Dragon (make TARGET=dragon).
    0.1.9  - 2019-06-03 - OS-9 supported, except for sound.
    0.1.10 - 2020-06-28 - Functions added: drawCharWithoutMovingCursor(), moveCursorLeft(),
                          invertCharAtCursor(), waitForKeyWithAnimatedCursor(), readLineFromKeyboard().
                          Removed PMODE4_PAGE0 and PMODE4_PAGE1: use
                              (byte *) (((word) * (byte *) 0x00BC) << 8)
                          to get the ECB PMODE buffer address instead.
    0.1.11 - 2023-06-27 - The library does not assume the presence of Basic anymore.
                          See section "Adapting to version 0.1.11" for details.
                          OS-9 support is suspended [restored with 0.1.12].
    0.1.12 - 2024-06-08 - Added setScreenBuffer2(), which allows to omit showing the screen.
                          Put several functions in individual C files to help reduce the size
                          of programs that do not use all functions of this library.
                          Added os9timer-demo.c to the archive generated by 'make dist'.
    0.1.13 - 2025-11-16   Added drawCompiledCard2(), which supports drawing the suit a little
                          higher or lower than the default, and supports only drawing the top
                          of a card, by specifying the number of pixel rows to draw.
                          Fixed drawCompiledPixMap() so that its inline assembly does not
                          refer to any global C variable in the code section that uses
                          the Y register. (That register is used under OS-9 to point to
                          the current process's global variables segment.) The old code
                          was not defective but its structure was error prone.
                          Added getCursor(), which returns the current position of the cursor.
                          Removed runPMode4GameDoubleBufferLoop(), which is obsolete.
