// By Pierre Sarrazin <http://sarrazip.com/>
// This file is in the public domain.
//
// This program must run under DECB.

#include "cardgame.h"


int main()
{
    initCoCoSupport();
    resetPalette(TRUE);
    initSound();

    byte duration = 50;
    word freq = 220;
    byte volume = BEEP_MAX_VOL;
    word spacing = 16;
    byte showPrompt = TRUE;
    for (;;)
    {
        if (showPrompt)
        {
            printf("bEEP\n"
                   "wHITE NOISE\n"
                   "dURATION: %u\n"
                   "sPACING:  %u\n"
                   "fREQ:     %u HZ\n"
                   "qUIT\n",
                   duration, spacing, freq);
            printf("COMMAND? ");
        }
        byte key = (byte) toupper(waitkey(TRUE));
        if (key == 'Q')
        {
            printf("\n");
            break;
        }
        showPrompt = FALSE;
        switch (key)
        {
        case 'B':
            beep(duration, getTicksForFrequency(freq), volume);
            break;
        case 'W':
            whiteNoise(duration, spacing, volume);
            break;
        case 'D':
            {
                printf("\n""NEW DURATION (1-255)? ");
                word w = readword();
                if (w == 0 || w > 255)
                    printf("INVALID.\n");
                else
                    duration = (byte) w;
                showPrompt = TRUE;
                break;
            }
        case 'F':  // frequency: only for beep
            {
                printf("\n""NEW FREQUENCY (HZ)? ");
                word w = readword();
                if (w < 20 || w > 20000)
                    printf("INVALID.\n");
                else
                    freq = w;
                showPrompt = TRUE;
                break;
            }
        case 'S':  // spacing: only for white noise
            {
                printf("\n""NEW SPACING (0-65535)? ");
                spacing = readword();
                showPrompt = TRUE;
                break;
            }
        }
    }

    printf("END.\n");
    return 0;
}
