// By Pierre Sarrazin <http://sarrazip.com/>
// This file is in the public domain.

#include "cardgame.h"


extern dword beep_cpuFreqDiv16;


word
getTicksForFrequency(word hertz)
{
    return (word) (beep_cpuFreqDiv16 / hertz) - 2;
}


void
beep(byte duration, word ticks, byte volume)
{
    byte shiftedVolume = volume << 2;
    asm
    {
; Nops are inserted so that an equal number of cycles is spent in each
; of the two phases of the square wave.
; The @halfSquareWave routine takes a number of cycles equal to
; 2 + 5 + 6 + ticks * (5 + 3) + 5, i.e.,
; 18 + 8 * ticks.
; If we want a square wave of frequency F (e.g., 200 Hz),
; then we want a half period of 1 / F / 2 (e.g., 0.0025 s),
; If the CPU frequency is C (e.g., 894886 Hz),
; then the number of cycles for one half period is C / F / 2 (e.g., 2237.22 cycles).
; Hence, 18 + 8 * ticks == C / F / 2,
; i.e., ticks = C / F / 16 - 2.25 (e.g., 277.402 ticks).
;
@loop
        lda     :shiftedVolume          ; 5 cycles in low phase
        bsr     @halfSquareWave         ; 7+N cycles in high phase
        lda     #0                      ; 2 cycles in high phase
        lbrn    @loop                   ; 5 cycles in high phase
        lbrn    @loop                   ; 5 cycles in high phase
        brn     @loop                   ; 3 cycles in high phase
        bsr     @halfSquareWave         ; 7+N cycles in low phase
        dec     :duration               ; 7 cycles in low phase
        bne     @loop                   ; 3 cycles in low phase
        bra     @done
@halfSquareWave
        anda    #$FC    ; keep 6 high bits      ; 2 cycles
        sta     $FF20   ; send                  ; 5 cycles
        ldx     :ticks                          ; 6 cycles
@sleep
        leax    -1,x                            ; 5 cycles
        bne     @sleep                          ; 3 cycles
        rts                                     ; 5 cycles
@done
    }
}


