/*  compiled-cards.c - Playing card bitmaps for the Color Computer.

    By Pierre Sarrazin <http://sarrazip.com/>.
    This file is in the public domain.

    Version 0.1.1 - 2016-03-12 - First release in the public domain.
    Version 0.1.2 - 201?-??-?? - Adapted to compile in linker mode.
*/

#include "compiled-cards.h"


const unsigned short 	redCard_1[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
};
const unsigned short 	redCard_2[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
};
const unsigned short 	redCard_3[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3EBF,  /* #  rr    0011111010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_4[10] = {
	0x3FBF,  /* #   r    0011111110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
};
const unsigned short 	redCard_5[10] = {
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3AFF,  /* # rr     0011101011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_6[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3AFF,  /* # rr     0011101011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_7[10] = {
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3F7F,  /* #   b    0011111101111111 */
	0x3EFF,  /* #  r     0011111011111111 */
	0x3EFF,  /* #  r     0011111011111111 */
	0x3EFF,  /* #  r     0011111011111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_8[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_9[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_10[10] = {
	0x3BAB,  /* # r rrr  0011101110101011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BBB,  /* # r r r  0011101110111011 */
	0x3BAB,  /* # r rrr  0011101110101011 */
};
const unsigned short 	redCard_11[10] = {
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short 	redCard_12[10] = {
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3FBF,  /* #   r    0011111110111111 */
};
const unsigned short 	redCard_13[10] = {
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3B7F,  /* # r b    0011101101111111 */
	0x3AFF,  /* # rr     0011101011111111 */
	0x3AFF,  /* # rr     0011101011111111 */
	0x3ABF,  /* # rrr    0011101010111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
	0x3BBF,  /* # r r    0011101110111111 */
};
const unsigned short 	blackCard_1[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
};
const unsigned short 	blackCard_2[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x383F,  /* # r##    0011100000111111 */
	0x307F,  /* # ##b    0011000001111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x303F,  /* # ###    0011000000111111 */
};
const unsigned short 	blackCard_3[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x387F,  /* # r#b    0011100001111111 */
	0x387F,  /* # r#b    0011100001111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x387F,  /* # r#b    0011100001111111 */
};
const unsigned short 	blackCard_4[10] = {
	0x3F3F,  /* #   #    0011111100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
};
const unsigned short 	blackCard_5[10] = {
	0x303F,  /* # ###    0011000000111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x307F,  /* # ##b    0011000001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x307F,  /* # ##b    0011000001111111 */
};
const unsigned short 	blackCard_6[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x307F,  /* # ##b    0011000001111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x307F,  /* # ##b    0011000001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x387F,  /* # r#b    0011100001111111 */
};
const unsigned short 	blackCard_7[10] = {
	0x303F,  /* # ###    0011000000111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3E7F,  /* #  rb    0011111001111111 */
	0x3E7F,  /* #  rb    0011111001111111 */
	0x3CFF,  /* #  #     0011110011111111 */
	0x3CFF,  /* #  #     0011110011111111 */
	0x3CFF,  /* #  #     0011110011111111 */
	0x3CFF,  /* #  #     0011110011111111 */
};
const unsigned short 	blackCard_8[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x387F,  /* # r#b    0011100001111111 */
	0x387F,  /* # r#b    0011100001111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x387F,  /* # r#b    0011100001111111 */
};
const unsigned short 	blackCard_9[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x383F,  /* # r##    0011100000111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x383F,  /* # r##    0011100000111111 */
	0x387F,  /* # r#b    0011100001111111 */
};
const unsigned short 	blackCard_10[10] = {
	0x3387,  /* # # r#b  0011001110000111 */
	0x3303,  /* # # ###  0011001100000011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3333,  /* # # # #  0011001100110011 */
	0x3303,  /* # # ###  0011001100000011 */
	0x3387,  /* # # r#b  0011001110000111 */
};
const unsigned short 	blackCard_11[10] = {
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x387F,  /* # r#b    0011100001111111 */
};
const unsigned short 	blackCard_12[10] = {
	0x387F,  /* # r#b    0011100001111111 */
	0x303F,  /* # ###    0011000000111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x323F,  /* # #r#    0011001000111111 */
	0x301F,  /* # ###b   0011000000011111 */
	0x381F,  /* # r##b   0011100000011111 */
};
const unsigned short 	blackCard_13[10] = {
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x30FF,  /* # ##     0011000011111111 */
	0x30FF,  /* # ##     0011000011111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
	0x333F,  /* # # #    0011001100111111 */
};

const unsigned short * const redCards[13] = {
redCard_1,
redCard_2,
redCard_3,
redCard_4,
redCard_5,
redCard_6,
redCard_7,
redCard_8,
redCard_9,
redCard_10,
redCard_11,
redCard_12,
redCard_13,
};
const unsigned short * const blackCards[13] = {
blackCard_1,
blackCard_2,
blackCard_3,
blackCard_4,
blackCard_5,
blackCard_6,
blackCard_7,
blackCard_8,
blackCard_9,
blackCard_10,
blackCard_11,
blackCard_12,
blackCard_13,
};

const unsigned short suit_hearts[7] = {
	0xEBAF,  /*  rr rr   1110101110101111 */
	0xAAAB,  /* rrrrrrr  1010101010101011 */
	0xAAAB,  /* rrrrrrr  1010101010101011 */
	0xAAAB,  /* rrrrrrr  1010101010101011 */
	0xEAAF,  /*  rrrrr   1110101010101111 */
	0xFABF,  /*   rrr    1111101010111111 */
	0xFEFF,  /*    r     1111111011111111 */
};
const unsigned short suit_spades[7] = {
	0xFCFF,  /*    #     1111110011111111 */
	0xF03F,  /*   ###    1111000000111111 */
	0xC00F,  /*  #####   1100000000001111 */
	0x0003,  /* #######  0000000000000011 */
	0xC00F,  /*  #####   1100000000001111 */
	0xFCFF,  /*    #     1111110011111111 */
	0xFCFF,  /*    #     1111110011111111 */
};
const unsigned short suit_diamonds[7] = {
	0xFEFF,  /*    r     1111111011111111 */
	0xFABF,  /*   rrr    1111101010111111 */
	0xEAAF,  /*  rrrrr   1110101010101111 */
	0xAAAB,  /* rrrrrrr  1010101010101011 */
	0xEAAF,  /*  rrrrr   1110101010101111 */
	0xFABF,  /*   rrr    1111101010111111 */
	0xFEFF,  /*    r     1111111011111111 */
};
const unsigned short suit_clubs[7] = {
	0xF03F,  /*   ###    1111000000111111 */
	0xF03F,  /*   ###    1111000000111111 */
	0xF03F,  /*   ###    1111000000111111 */
	0x0003,  /* #######  0000000000000011 */
	0x0003,  /* #######  0000000000000011 */
	0x0CC3,  /* ## # ##  0000110011000011 */
	0xFCFF,  /*    #     1111110011111111 */
};

const unsigned short * const suits[4] = { suit_hearts, suit_spades, suit_diamonds, suit_clubs };

const unsigned short cardTopLeft[5] = {
	0x0000,  /* ######## 0000000000000000 */
	0x07FF,  /* ##b      0000011111111111 */
	0x1FFF,  /* #b       0001111111111111 */
	0x1FFF,  /* #b       0001111111111111 */
	0x1FFF,  /* #b       0001111111111111 */
};
const unsigned short cardBottomLeft[5] = {
	0x1FFF,  /* #b       0001111111111111 */
	0x1FFF,  /* #b       0001111111111111 */
	0x1FFF,  /* #b       0001111111111111 */
	0x07FF,  /* ##b      0000011111111111 */
	0x0000,  /* ######## 0000000000000000 */
};
const unsigned short cardTopRight[5] = {
	0x0000,  /* ######## 0000000000000000 */
	0xFFC0,  /*      ### 1111111111000000 */
	0xFFF0,  /*       ## 1111111111110000 */
	0xFFF0,  /*       ## 1111111111110000 */
	0xFFF0,  /*       ## 1111111111110000 */
};
const unsigned short cardBottomRight[5] = {
	0xFFF0,  /*       ## 1111111111110000 */
	0xFFF0,  /*       ## 1111111111110000 */
	0xFFF0,  /*       ## 1111111111110000 */
	0xFFC0,  /*      ### 1111111111000000 */
	0x0000,  /* ######## 0000000000000000 */
};
const unsigned short cardLeft[1] = {
	0x3FFF,  /* #        0011111111111111 */
};
const unsigned short cardRight[1] = {
	0xFFF8,  /*       r# 1111111111111000 */
};
const unsigned short redJokerValue[10] = {
	0x3EFF,  /* #  r     0011111011111111 */
	0x3EBF,  /* #  rr    0011111010111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3BFF,  /* # r      0011101111111111 */
	0x3EFF,  /* #  r     0011111011111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3FBF,  /* #   r    0011111110111111 */
	0x3AFF,  /* # rr     0011101011111111 */
	0x3EFF,  /* #  r     0011111011111111 */
};
const unsigned short blackJokerValue[10] = {
	0x3CFF,  /* #  #     0011110011111111 */
	0x3C3F,  /* #  ##    0011110000111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x33FF,  /* # #      0011001111111111 */
	0x3CFF,  /* #  #     0011110011111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x3F3F,  /* #   #    0011111100111111 */
	0x30FF,  /* # ##     0011000011111111 */
	0x3CFF,  /* #  #     0011110011111111 */
};
const unsigned short redJokerSuit[7] = {
	0xAAAB,  /* rrrrrrr  1010101010101011 */
	0xAABB,  /* rrrrr r  1010101010111011 */
	0xAABB,  /* rrrrr r  1010101010111011 */
	0xAABB,  /* rrrrr r  1010101010111011 */
	0xBABB,  /* r rrr r  1011101010111011 */
	0xAFEB,  /* rr   rr  1010111111101011 */
	0xAAAB,  /* rrrrrrr  1010101010101011 */
};
const unsigned short blackJokerSuit[7] = {
	0x0003,  /* #######  0000000000000011 */
	0x0033,  /* ##### #  0000000000110011 */
	0x0033,  /* ##### #  0000000000110011 */
	0x0033,  /* ##### #  0000000000110011 */
	0x3033,  /* # ### #  0011000000110011 */
	0x0FC3,  /* ##   ##  0000111111000011 */
	0x0003,  /* #######  0000000000000011 */
};
