#include "pmode4game_private.h"


void
drawChar(unsigned char c)
{
    if (c == '\n')
        textPosX = BYTES_PER_SCREEN_ROW - 1;  // go to end of current line
    else
        drawCharWithoutMovingCursor(c);
    
    // Advance cursor.
    if (textPosX == BYTES_PER_SCREEN_ROW - 1)  // if column finished, go to next row
    {
        textPosX = 0;
        if (textPosY == TEXT_ROWS_PER_SCREEN - 1)  // if at last row, wrap around
        {
            if (textAreaScrollCallback)
            {
                // This may call moveCursor(), which may change textPosX and textPosY.
                (*textAreaScrollCallback)(textAreaScrollCallbackUserData);
            }
            else
                textPosY = 0;  // wrap around
        }
        else
            ++textPosY;
    }
    else
        ++textPosX;
}

