#include "cardgame.h"


byte colorInversionMask = 0x00;  // 0xFF to write in black on white


void
drawCharAtAddressWithoutMovingCursor(unsigned char c, byte *dest, BOOL drawBottomRow)
{
    if (c < ' ' || c > ']')  // mask undefined glyphs
        c = '?';

    const byte *src = eightBitWideFont[c - ' '];
    for (byte i = 0; i < PIXEL_ROWS_PER_GLYPH; ++i)
    {
        *dest = *src++ ^ colorInversionMask;
        dest += BYTES_PER_SCREEN_ROW;
    }
    if (drawBottomRow)
        *dest = colorInversionMask;  // additional row below glyph -- total of 8 rows
}


void
drawCharWithoutMovingCursor(unsigned char c)
{
    drawCharAtAddressWithoutMovingCursor(c, getCurrentCharPos(), TRUE);
}
