/*  8-bit-wide-font.c - 8x8 font for the Color Computer

    By Pierre Sarrazin <http://sarrazip.com/>.
    This file is in the public domain.

    Does not include glyphs from 94 to 127 (i.e., no lower case letters).
    Size in memory: 434 bytes.
    In the 8x8 grid, the two left-most columns are always empty, i.e.,
    the two highest bits in each byte are 0.
*/

#include "8-bit-wide-font.h"


const unsigned char eightBitWideFont[][7] = {
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },  //   ( 32, 0x20)
{ 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x0C, },  // ! ( 33, 0x21)
{ 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, },  // " ( 34, 0x22)
{ 0x1E, 0x1E, 0x1E, 0x3F, 0x1E, 0x1E, 0x1E, },  // # ( 35, 0x23)
{ 0x0C, 0x1E, 0x30, 0x3F, 0x03, 0x1E, 0x0C, },  // $ ( 36, 0x24)
{ 0x33, 0x33, 0x06, 0x0C, 0x18, 0x33, 0x33, },  // % ( 37, 0x25)
{ 0x1C, 0x36, 0x30, 0x18, 0x3C, 0x36, 0x1B, },  // & ( 38, 0x26)
{ 0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, },  // ' ( 39, 0x27)
{ 0x03, 0x06, 0x0C, 0x0C, 0x0C, 0x06, 0x03, },  // ( ( 40, 0x28)
{ 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, },  // ) ( 41, 0x29)
{ 0x00, 0x0C, 0x1E, 0x3F, 0x1E, 0x0C, 0x00, },  // * ( 42, 0x2A)
{ 0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, },  // + ( 43, 0x2B)
{ 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x18, },  // , ( 44, 0x2C)
{ 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, },  // - ( 45, 0x2D)
{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, },  // . ( 46, 0x2E)
{ 0x03, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x30, },  // / ( 47, 0x2F)
{ 0x1E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, },  // 0 ( 48, 0x30)
{ 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, },  // 1 ( 49, 0x31)
{ 0x1E, 0x33, 0x03, 0x06, 0x0C, 0x18, 0x3F, },  // 2 ( 50, 0x32)
{ 0x1E, 0x33, 0x03, 0x0E, 0x03, 0x33, 0x1E, },  // 3 ( 51, 0x33)
{ 0x33, 0x33, 0x33, 0x3F, 0x03, 0x03, 0x03, },  // 4 ( 52, 0x34)
{ 0x3F, 0x30, 0x30, 0x3E, 0x03, 0x03, 0x3E, },  // 5 ( 53, 0x35)
{ 0x1E, 0x33, 0x30, 0x3E, 0x33, 0x33, 0x1E, },  // 6 ( 54, 0x36)
{ 0x3F, 0x03, 0x03, 0x06, 0x0C, 0x0C, 0x0C, },  // 7 ( 55, 0x37)
{ 0x1E, 0x33, 0x33, 0x1E, 0x33, 0x33, 0x1E, },  // 8 ( 56, 0x38)
{ 0x1E, 0x33, 0x33, 0x1F, 0x03, 0x33, 0x1E, },  // 9 ( 57, 0x39)
{ 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00, },  // : ( 58, 0x3A)
{ 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x18, },  // ; ( 59, 0x3B)
{ 0x03, 0x06, 0x0C, 0x18, 0x0C, 0x06, 0x03, },  // < ( 60, 0x3C)
{ 0x00, 0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, },  // = ( 61, 0x3D)
{ 0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x30, },  // > ( 62, 0x3E)
{ 0x1E, 0x33, 0x03, 0x06, 0x0C, 0x00, 0x0C, },  // ? ( 63, 0x3F)
{ 0x1E, 0x33, 0x03, 0x1F, 0x33, 0x33, 0x1E, },  // @ ( 64, 0x40)
{ 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, },  // A ( 65, 0x41)
{ 0x3E, 0x33, 0x33, 0x3E, 0x33, 0x33, 0x3E, },  // B ( 66, 0x42)
{ 0x1E, 0x33, 0x30, 0x30, 0x30, 0x33, 0x1E, },  // C ( 67, 0x43)
{ 0x3E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3E, },  // D ( 68, 0x44)
{ 0x3F, 0x30, 0x30, 0x3C, 0x30, 0x30, 0x3F, },  // E ( 69, 0x45)
{ 0x3F, 0x30, 0x30, 0x3C, 0x30, 0x30, 0x30, },  // F ( 70, 0x46)
{ 0x1F, 0x30, 0x30, 0x33, 0x33, 0x33, 0x1F, },  // G ( 71, 0x47)
{ 0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, },  // H ( 72, 0x48)
{ 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, },  // I ( 73, 0x49)
{ 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x1E, },  // J ( 74, 0x4A)
{ 0x33, 0x33, 0x36, 0x3C, 0x36, 0x33, 0x33, },  // K ( 75, 0x4B)
{ 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3F, },  // L ( 76, 0x4C)
{ 0x33, 0x3F, 0x3F, 0x3F, 0x33, 0x33, 0x33, },  // M ( 77, 0x4D)
{ 0x33, 0x33, 0x3B, 0x3F, 0x37, 0x33, 0x33, },  // N ( 78, 0x4E)
{ 0x1E, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, },  // O ( 79, 0x4F)
{ 0x3E, 0x33, 0x33, 0x3E, 0x30, 0x30, 0x30, },  // P ( 80, 0x50)
{ 0x1E, 0x33, 0x33, 0x33, 0x33, 0x36, 0x1F, },  // Q ( 81, 0x51)
{ 0x3E, 0x33, 0x33, 0x3E, 0x3C, 0x36, 0x33, },  // R ( 82, 0x52)
{ 0x1E, 0x33, 0x30, 0x0C, 0x03, 0x33, 0x1E, },  // S ( 83, 0x53)
{ 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, },  // T ( 84, 0x54)
{ 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, },  // U ( 85, 0x55)
{ 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, },  // V ( 86, 0x56)
{ 0x33, 0x33, 0x33, 0x3F, 0x3F, 0x3F, 0x33, },  // W ( 87, 0x57)
{ 0x33, 0x33, 0x1E, 0x0C, 0x1E, 0x33, 0x33, },  // X ( 88, 0x58)
{ 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, },  // Y ( 89, 0x59)
{ 0x3F, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x3F, },  // Z ( 90, 0x5A)
{ 0x0F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, },  // [ ( 91, 0x5B)
{ 0x30, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x03, },  // \ ( 92, 0x5C)
{ 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, },  // ] ( 93, 0x5D)
};
