#ifndef _H_OS9Timer
#define _H_OS9Timer

#include <coco.h>


#ifdef OS9


// Initializes a timer system that maintains a 16-bit unsigned counter.
// This counters wraps to 0 when it passes 65535.
//
// ticksPerIncrement: How many sixtieths of a second before the timer is incremented by 1.
//                    Pass 1 to have a counter similar to Color Basic's TIMER.
//
// Call OS9Timer_shutdown() when finished with the use of the timer.
//
// CAUTION: OS-9 F$Sleep call gets stopped by the interrupts caused by this timer system.
//          This means that CMOC's delay() function is affected too.
//          Delays may be achieved with OS9Timer_delay() instead.
//
byte OS9Timer_init(unsigned ticksPerIncrement);


// Releases the resources used by this timer system.
//
byte OS9Timer_shutdown(void);


// Returns the current value of the periodically incremented counter.
//
word OS9Timer_getTimer(void);


// Changes the current value of the periodically incremented counter.
//
void OS9Timer_setTimer(word newValue);


// Wait for the specified number of increments to have been made to the counter.
// Can be used as a replacement for the F$Sleep system call and for the delay() function.
//
void OS9Timer_delay(word ticksToWait);


#endif  /* OS9 */


#endif  /* _H_OS9Timer */
