/*  cardgame.c
    Skeleton CoCo program that draws playing cards.
   
    By Pierre Sarrazin <http://sarrazip.com/>.
    This file is in the public domain.
*/

#include "cardgame.h"


int
main()
{
    // Initialize the PMODE 4 screen.
    // Under OS-9, no screen buffer address is passed because the system chooses it.
    // This initializes the (global) scrnBuffer pointer.
    // Use showGraphicsAddress() to point to another PMODE 4 buffer later
    // (not supported under OS-9).
    // CoCo 3 emulation of artifact colors is not supported under OS-9.
    #ifdef OS9
    openCardGame(NULL, FALSE);
    #else
    openCardGame((void *) (((word) * (byte *) 0x00BC) << 8), TRUE);
    #endif

    // Precompute the number of pixel rows per card, for the coming loops.
    byte cardHeight = getNumPixelRowsPerCard();

    // Draw the 52 ordinary cards in a grid, which each card overlapping
    // its predecessor in the current row.
    byte pixelRow = 0;
    byte horizSkip = 4;
    for (byte suit = SUIT_HEARTS; suit <= SUIT_CLUBS; ++suit, pixelRow += cardHeight + horizSkip)
    {
        for (byte value = 1; value <= 13; ++value)  // ace to king
        {
            byte byteCol = (value - 1) << 1;  // 2 bytes of visible width per card (other 2 bytes gets overlapped)
            drawCompiledCard(value, suit, byteCol, pixelRow);
        }
    }

    // Draw the two jokers at top right.
    for (byte joker = 1; joker <= 2; ++joker)
        drawCompiledCard(joker, SUIT_JOKER, 28, (joker - 1) * (cardHeight + 4));

    // Draw a face-down card at bottom right.
    drawFaceDownCard(PIXEL_ROWS_PER_SCREEN - getNumPixelRowsPerCard(), 28);

    // Show a prompt at the bottom and wait for the user to quit.
    moveCursor(0, 23);
    #ifdef OS9  // Only a delay, because no waitkey()
    word delayInSeconds = 5;
    printf("QUITTING AFTER %u SECONDS.", delayInSeconds);
    delay(delayInSeconds * 60);
    #else
    printf("PRESS BREAK TO QUIT.");
    while (waitkey(FALSE) != 3)
        ;
    #endif

    // Erase the jokers over a short delay, as an example of erasing cards.
    eraseCard(28, cardHeight + 4);
    delay(30);
    eraseCard(28, 0);
    delay(30);

    // Go back to the text screen.
    closeCardGame();
    #ifdef OS9
    putstr("\x12\x0E", 2);
    #else
    width(32);
    screen(0, 0);
    cls(255);
    #endif

    // printf() now prints to the hardware CoCo text screen.
    printf("THANKS FOR PLAYING.\n");
    return 0;
}
