#include "cardgame.h"

#include "pmode4game_private.h"


void
drawCharAtAddressWithoutMovingCursor(unsigned char c, byte *dest, BOOL drawBottomRow)
{
    if (c == ' ' && transparentSpaceChar)
        return;  // nothing to do
    if (c < ' ' || c > ']')  // mask undefined glyphs
        c = '?';

    BOOL drawRight = (colorInversionMask == 0xFF
                        && drawColumnAtRightOfGlyphWhenColorsInverted
                        && ((byte) (word) dest & 0x1F) < 0x1F);

    if (colorInversionMask == 0xFF
            && drawRowOverGlyphWhenColorsInverted
            && dest >= scrnBuffer + BYTES_PER_SCREEN_ROW)
    {
        dest[-BYTES_PER_SCREEN_ROW] = colorInversionMask;
        if (drawRight)
            dest[1 - BYTES_PER_SCREEN_ROW] |= 0xC0;
    }

    const byte *src = eightBitWideFont[c - ' '];
    for (byte i = 0; i < PIXEL_ROWS_PER_GLYPH; ++i)
    {
        *dest = *src++ ^ colorInversionMask;
        if (drawRight)
            dest[1] |= 0xC0;
        dest += BYTES_PER_SCREEN_ROW;
    }
    if (drawBottomRow)
    {
        *dest = colorInversionMask;  // additional row below glyph -- total of 8 rows
        if (drawRight)
            dest[1] |= 0xC0;
    }
}


void
drawCharWithoutMovingCursor(unsigned char c)
{
    drawCharAtAddressWithoutMovingCursor(c, getCurrentCharPos(), TRUE);
}
