#include "cardgame.h"


int main()
{
    byte err = OS9Timer_init(1);  // increment a counter at every 60 Hz tick
    if (err != 0)
    {
        printf("Failed to init OS-9 timer: error #%u\n", err);
        return 1;
    }

    word seconds;
    do
    {
        word t = OS9Timer_getTimer();
        seconds = t / 60;
        printf("%5u ticks, %4u s\n", t, seconds);
    } while (seconds < 5);

    err = OS9Timer_shutdown();
    if (err != 0)
    {
        printf("Failed to close OS-9 timer: error #%u\n", err);
        return 1;
    }

    return 0;
}
