/*  pmode4game.c - PMODE 4 game library for the CoCo.
    Assumes Disk Basic, i.e., the PMODE 4 screen starts at $0E00.
   
    By Pierre Sarrazin <http://sarrazip.com/>.
    This file is in the public domain.
*/

#include "cardgame.h"

#include "pmode4game_private.h"


///////////////////////////////////////////////////////////////////////////////


void
openPMode4Game(void *_scrnBuffer, byte _emulatePMode4OnCoCo3)
{
    initCoCoSupport();

    emulatingPMode4OnCoCo3 = _emulatePMode4OnCoCo3;

#ifdef OS9
    // Source: OS-9 Operating System User's Guide:
    // For Use with OS-9 Level Oneand OS-9 Level Two
    //
    // The terminal from which this is run must already be in a VDG screen mode.
    //
    putstr("\x0F\x00\x05\x13", 4); // 256x192x2, white on black; Clear Screen
    asm
    {
        pshs    y           ; protect global variable segment pointer
        lda     #1
        ldb     #$12        ; SS.DSTAT (Get Display Status)
        os9     $8D         ; I$GSTT
        puls    y
        stx     :scrnBuffer
    }
#else
    scrnBuffer = (byte *) _scrnBuffer;

    pmode(4, scrnBuffer);
    pcls(0);
    if (isCoCo3 && emulatingPMode4OnCoCo3)
    {
        * (byte *) 0xFF90 = 0x7E;  // not CoCo compatible mode
        * (byte *) 0xFF98 = 0x80;  // graphics mode
        * (byte *) 0xFF99 = 0x09;  // 192 pixel rows, 32 bytes per row, 4 pixels per byte (i.e., 128x192, 4 colors)
        * (byte *) 0xFF9A = 0xFF;  // white border
        * (void **) 0xFF9D = 0xE000 | (scrnBuffer >> 3);  // typically, $70E00 / 8.
        memcpy((byte *) 0xFFB0, "\x00\x0B\x34\xFF", 4);  // palette slots 0..3: black, blue, orange, white
    }
    else
        screen(1, 1);  // white/black
#endif
    
    // Hi-res text screen:
    moveCursor(0, 0);
    
    // Set screen dimensions for functions in coco.h.
    textScreenWidth  = TEXT_COLS_PER_ROW;
    textScreenHeight = TEXT_ROWS_PER_SCREEN;

    // Redirect printf().
    oldCHROUT = setConsoleOutHook(hiResTextConsoleOutHook);
}


void closePMode4Game(void)
{
    setConsoleOutHook(oldCHROUT);
}
