#include "cardgame.h"


BOOL
readLineFromKeyboard(KeyboardPollFunction poll,
                     void *userdata,
                     word ticksPerCursorPeriod,
                     GetTimerFunction getTimerValue,
                     char *lineBuffer, size_t bufferSize)
{
    size_t bufIndex = 0;
    for (;;)
    {
        byte key = waitForKeyWithAnimatedCursor(poll, userdata, ticksPerCursorPeriod, getTimerValue);
        switch (key)
        {
            case '\r':
                lineBuffer[bufIndex] = '\0';
                return TRUE;
            case 3:  // break
                return FALSE;
            case '\b':  // backspace
                if (bufIndex > 0)
                {
                    --bufIndex;
                    moveCursorLeft(1);
                    drawCharWithoutMovingCursor(' ');
                }
                break;
            default:
                if (key >= ' ' && key <= ']')
                {
                    if (bufIndex < bufferSize - 1)  // minus one, to leave space for final '\0'
                    {
                        lineBuffer[bufIndex++] = (char) key;
                        drawChar(key);
                    }
                }
        }
    }
}
