#include "cardgame.h"

#ifdef OS9
#define getTimer() (OS9Timer_getTimer())
#endif


byte
waitForKeyWithAnimatedCursor(KeyboardPollFunction poll,
                             void *userdata,
                             word ticksPerCursorPeriod,
                             GetTimerFunction getTimerValue)
{
    byte prevCursorState;
    word nearEndOfPeriod;
    if (ticksPerCursorPeriod > 0)  // if cursor wanted
    {
        invertCharAtCursor();
        prevCursorState = 1;
        nearEndOfPeriod = ticksPerCursorPeriod * 3 / 4;
    }
    else
        prevCursorState = 0;

    byte key;
    while ((key = (*poll)(userdata)) == 0)
    {
        if (ticksPerCursorPeriod > 0)
        {
            word now = (*getTimerValue)(userdata);
            byte currentCursorState = (now % ticksPerCursorPeriod < nearEndOfPeriod);
            if (currentCursorState != prevCursorState)
            {
                invertCharAtCursor();
                prevCursorState = currentCursorState;
            }
        }
    }
    if (prevCursorState)
        invertCharAtCursor();
    return key;
}
