// By Pierre Sarrazin <http://sarrazip.com/>
// This file is in the public domain.

#include "cardgame.h"


#define NUM_BYTES 32

static const byte uniformlyRandomBytes[NUM_BYTES] =
{
    0x08, 0xf0, 0xfc, 0x9c, 0x94, 0xc8, 0xd4, 0x74, 0xd4, 0x20, 0x04, 0xac, 0xb4, 0x68, 0xe0, 0x08, 
    0x74, 0x20, 0x28, 0x64, 0x24, 0xa4, 0xcc, 0xb8, 0x58, 0xa0, 0x54, 0x7c, 0x04, 0x44, 0x84, 0xb0, 
};


void
whiteNoise(word duration, word spacing, byte volume)
{
    asm
    {
        leax    :uniformlyRandomBytes
        pshs    y
        ldy     :duration
; Cannot refer to globals anymore under OS-9, as per CMOC register convention.
@durationLoop
        ldb     #NUM_BYTES         ; size of uniformlyRandomBytes[]
@writeLoop
        lda     ,x+
        sta     $FF20
        bsr     @sleep
        decb
        bne     @writeLoop
        leax    -NUM_BYTES,x
        leay    -1,y        ; decrement duration
        bne     @durationLoop
;
        puls    y
        bra     @done
@sleep
        pshs    x
        ldx     :spacing
        beq     @sleepDone
@sleepLoop
        leax    -1,x
        bne     @sleepLoop
@sleepDone
        puls    x,pc
@done
    }
}
