
#line 3 "lexer.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 52
#define YY_END_OF_BUFFER 53
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[152] =
    {   0,
        0,    0,   53,   51,    4,    5,   51,   51,   51,   51,
       51,   51,   51,   51,   51,   51,   33,   33,   51,   51,
       51,   34,   51,   34,   51,   51,    4,   51,   51,    4,
        0,    9,    0,   35,    0,   16,   20,   18,    0,   36,
        0,   14,    7,   12,    6,   13,   26,    0,   30,   15,
       31,   33,    0,    0,   33,    0,   22,   10,    8,   11,
       23,   34,   17,   34,   19,   21,    4,    0,    0,    0,
        0,    0,    0,   35,   50,    0,   50,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   27,    0,
       30,    0,   31,   29,    0,   32,   28,   24,   25,   34,

        0,    0,   46,   45,   37,    0,   49,    0,   47,   38,
       39,   43,   41,   44,   40,   42,    0,    0,   30,    0,
       31,   29,   32,   28,    0,    0,    0,    0,    0,    0,
       48,    0,    0,    0,    3,    0,    0,    0,    0,    0,
        0,    1,    0,    0,    0,    0,    0,    0,    2,    0,
        0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    1,    8,    9,   10,    1,
        1,   11,   12,    1,   13,   14,   15,   16,   17,   18,
       18,   18,   18,   18,   18,   19,   19,    1,    1,   20,
       21,   22,    1,    1,   23,   24,   23,   23,   25,   26,
       27,   27,   27,   27,   27,   28,   27,   27,   27,   27,
       27,   27,   27,   27,   28,   27,   27,   29,   27,   27,
        1,   30,    1,   31,   27,    1,   32,   33,   23,   23,

       25,   34,   35,   27,   27,   27,   27,   28,   36,   37,
       27,   38,   27,   39,   40,   41,   28,   42,   27,   43,
       27,   27,   44,   45,   46,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,   47,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,   48,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[49] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    3,
        1,    1,    1,    1,    1,    4,    4,    4,    4,    1,
        1,    1,    4,    4,    4,    4,    5,    5,    5,    1,
        1,    4,    4,    4,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    6,    1,    1,    1,    1
    } ;

static const flex_int16_t yy_base[162] =
    {   0,
        0,   47,  338,  418,   51,  418,  316,   44,  315,   43,
       46,  314,   45,   46,   44,  299,   86,   61,   49,  298,
       50,    0,  296,  258,   52,  250,   80,   86,  235,   89,
      234,  418,   77,  418,   79,  418,  418,  418,  266,  265,
      132,  418,  418,  418,  418,  418,  418,  251,  127,  418,
      160,  173,   96,  104,  236,    0,  232,  418,  418,  418,
      227,    0,  418,  211,  418,  418,  152,  166,  186,  178,
      225,  193,  181,   95,  418,  214,  205,  192,  201,  202,
      196,  195,  193,  187,  186,  185,  183,    0,  418,  218,
      418,  233,  418,  123,  204,  240,  160,  418,  418,  236,

      251,  152,  418,  418,  418,  244,  418,  261,  418,  418,
      418,  418,  418,  418,  418,  418,  173,  269,  273,  277,
      284,  153,  418,  144,  302,   62,  120,  154,  123,  147,
      418,  145,   86,  101,  418,  135,   99,   85,  120,  305,
       86,  418,  309,  312,  327,   49,   89,  330,  418,  160,
      418,  378,  384,  387,   77,   61,  390,  394,  400,  405,
      411
    } ;

static const flex_int16_t yy_def[162] =
    {   0,
      151,    1,  151,  151,  151,  151,  151,  152,  151,  151,
      153,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  154,  151,  154,  151,  151,  151,  151,  151,  151,
      151,  151,  152,  151,  152,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  155,  151,  151,  151,  151,
      151,  154,  151,  154,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  152,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  156,  151,  151,
      151,  151,  151,  151,  151,  151,  155,  151,  151,  154,

      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  157,  151,  151,  151,
      151,  151,  151,  151,  151,  158,  151,  151,  151,  151,
      151,  151,  158,  159,  151,  160,  151,  159,  160,  160,
      151,  151,  160,  151,  161,  151,  161,  161,  151,  161,
        0,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151
    } ;

static const flex_int16_t yy_nxt[467] =
    {   0,
        4,    5,    6,    5,    7,    8,    4,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   18,   18,   19,
       20,   21,   22,   22,   22,   22,   22,   22,   22,    4,
       23,   24,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,    4,   25,    4,    5,   26,   27,   34,
       27,   37,   30,   28,   30,   40,   43,   48,   45,   49,
       49,   49,   49,   38,  117,   44,   46,   47,   57,   58,
       60,   61,   65,   35,   51,   41,   52,   52,   52,   52,
       97,   67,   34,   67,   74,   54,   68,   70,   55,   71,
       30,  149,   30,   27,   29,  145,   66,   30,   31,   51,

       34,   52,   52,   52,   52,  134,   35,  135,   35,   53,
       54,   94,   94,   55,   56,   95,   95,  144,   53,   96,
       96,   96,   96,   72,   35,  140,   67,   69,   56,  134,
      133,  135,   70,   73,  141,   30,   31,   76,   94,   94,
      140,   77,   49,   49,   49,   49,  133,   78,   79,   79,
      122,   90,   91,   67,  131,   67,  107,  137,   68,  136,
       91,   80,  149,   81,   82,   83,  125,   70,   84,   70,
       85,  124,   86,   87,   88,   49,   49,   49,   49,   70,
      122,   70,  131,  129,   92,   93,   51,  124,   52,   52,
       52,   52,  116,   93,  115,  114,  113,   54,   67,   69,

       55,  105,  112,   72,  111,  110,  148,  106,  106,  106,
      107,  109,   70,   73,  104,   72,  108,  108,  108,   96,
       96,   96,   96,  103,   70,   73,   70,   70,   70,  118,
      118,  102,   67,  119,  119,  119,  119,  125,  125,  125,
      101,  101,  101,  101,  120,  120,  100,   99,  121,  121,
      121,  121,   98,  107,  128,   96,   96,   96,   96,  108,
      108,  108,   72,   55,   89,  123,  101,  101,  101,  101,
      107,   70,   73,  123,   75,   75,  130,  130,  130,  126,
       30,   67,  125,  127,  119,  119,  119,  119,  119,  119,
      119,  119,  121,  121,  121,  121,   30,   64,   91,  121,

      121,  121,  121,  125,  125,  125,   91,  142,  143,   93,
      140,  142,  143,  145,  140,  145,   63,   93,   59,   50,
      143,  143,  143,  143,  143,  143,  143,  143,  148,  149,
      148,  148,  149,  148,   42,   36,   32,  151,  151,  151,
      151,  151,  151,  151,  151,  126,  151,  151,  125,  127,
      151,  151,  151,  151,  151,  151,  151,  151,  145,  146,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  148,  150,  151,  148,  150,   33,  151,
       33,   33,   33,   33,   39,  151,   39,   39,   39,   39,
       62,   62,  132,  132,  133,  133,  133,  133,  133,  133,

      138,  138,  138,  138,  138,  139,  151,  139,  139,  139,
      139,  147,  147,  147,  147,  147,  147,    3,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151
    } ;

static const flex_int16_t yy_chk[467] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    8,
        2,   10,    5,    2,    5,   11,   13,   15,   14,   15,
       15,   15,   15,   10,  156,   13,   14,   14,   19,   19,
       21,   21,   25,    8,   18,   11,   18,   18,   18,   18,
      155,   27,   33,   27,   35,   18,   27,   28,   18,   28,
       30,  147,   30,    2,    2,  146,   25,    5,    5,   17,

       74,   17,   17,   17,   17,  126,   33,  126,   35,   17,
       17,   53,   53,   17,   17,   54,   54,  141,   17,   54,
       54,   54,   54,   28,   74,  139,   27,   27,   17,  133,
      138,  133,   28,   28,  137,   30,   30,   41,   94,   94,
      136,   41,   49,   49,   49,   49,  134,   41,   41,   41,
       94,   49,   49,   67,  132,   67,  130,  129,   67,  128,
       49,   41,  150,   41,   41,   41,  127,   68,   41,   68,
       41,  124,   41,   41,   41,   51,   51,   51,   51,   70,
      122,   70,  117,  102,   51,   51,   52,   97,   52,   52,
       52,   52,   87,   51,   86,   85,   84,   52,   67,   67,

       52,   78,   83,   68,   82,   81,  150,   78,   78,   78,
       79,   80,   68,   68,   77,   70,   79,   79,   79,   95,
       95,   95,   95,   76,   70,   70,   71,   73,   71,   90,
       90,   72,   69,   90,   90,   90,   90,  100,  100,  100,
       71,   71,   71,   71,   92,   92,   64,   61,   92,   92,
       92,   92,   57,  106,  101,   96,   96,   96,   96,  106,
      106,  106,   71,   55,   48,   96,  101,  101,  101,  101,
      108,   71,   71,   96,   40,   39,  108,  108,  108,  100,
       31,   29,  100,  100,  118,  118,  118,  118,  119,  119,
      119,  119,  120,  120,  120,  120,   26,   24,  119,  121,

      121,  121,  121,  125,  125,  125,  119,  140,  140,  121,
      140,  143,  143,  144,  143,  144,   23,  121,   20,   16,
      140,  140,  140,  140,  143,  143,  143,  143,  145,  145,
      145,  148,  148,  148,   12,    9,    7,    3,    0,    0,
        0,    0,    0,    0,    0,  125,    0,    0,  125,  125,
        0,    0,    0,    0,    0,    0,    0,    0,  144,  144,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  145,  145,    0,  148,  148,  152,    0,
      152,  152,  152,  152,  153,    0,  153,  153,  153,  153,
      154,  154,  157,  157,  158,  158,  158,  158,  158,  158,

      159,  159,  159,  159,  159,  160,    0,  160,  160,  160,
      160,  161,  161,  161,  161,  161,  161,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.ll"
/* lexer.ll - Lexical analyser for GNU Flex */
#line 4 "lexer.ll"
#include <limits.h>
#include <string.h>
#include <string>

#include "DeclarationSequence.h"
#include "CompoundStmt.h"
#include "BinaryOpExpr.h"
#include "UnaryOpExpr.h"
#include "TranslationUnit.h"
#include "FunctionDef.h"
#include "ClassDef.h"
#include "FormalParameter.h"
#include "FormalParamList.h"
#include "DeclarationSpecifierList.h"
#include "FunctionPointerCast.h"

#define YY_NO_INPUT  /* do not generate yyinput() */

#include "parser.hh"  /* generated by bison -d */
    /*  Note for Automake users: version 1.12 or later is required
        to generate parser.hh. Previous versions generate parser.h.
    */

using namespace std;

string sourceFilename;
int lineno = 1;  // line number in the input text; first line is numbered 1


static bool doublePrecisionLiteralWarningIssued = false;

static void warnIfDoublePrecisionLiteral(const char *realLiteralText)
{
    if (!doublePrecisionLiteralWarningIssued && tolower(realLiteralText[strlen(realLiteralText) - 1]) != 'f')
    {
        warnmsg("double-precision numeric literals have same precision as `float' for this compiler");
        doublePrecisionLiteralWarningIssued = true;
    }
}


extern "C" int yywrap(void) { return 1; }  // yylex() returns 0 when EOF reached

bool isOctal(uint64_t &value, const char *str);

bool processPreprocessorLineDirective(char *&reader);
#line 643 "lexer.cc"
#line 56 "lexer.ll"
                /* A0 = Latin-1 unbreakable space; C2 A0 = same in UTF-8 */
#line 646 "lexer.cc"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 58 "lexer.ll"


        /*  WARNING:
            The opening brace for code that follows a pattern must be
            on the same line as the pattern.
            C-style comments must be indented so as not to be taken
            as lexical rules. 
        */


        /*  #include markers generated by cpp.
            Format: # NUM "FILENAME" [NUM ...]
            The 1st integer is the line number in FILENAME.
            One or more integers can appear after the filename. They are all ignored.
        */
#line 882 "lexer.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 152 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 418 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 73 "lexer.ll"
{ sscanf(yytext + 2, "%d", &lineno);
                                  lineno--;
                                  char *fn = strchr(yytext, '\"') + 1;
                                  char *end = strchr(fn, '\"');
                                  *end = '\0';
                                  sourceFilename = fn;
                                  TranslationUnit::instance().addPrerequisiteFilename(fn);
                                }
	YY_BREAK
/* Pragma directive. */
case 2:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 83 "lexer.ll"
{
                                    // Pragma directive.
                                    //
                                    const char *src = strstr(yytext, "pragma") + 6;
                                    for (++src; isspace(*src); ++src)
                                        ;
                                    yylval.str = strdup(src);
                                    return PRAGMA; 
                                }
	YY_BREAK
/* Inline assembly: asm { ... }. Accept balanced braces inside the outer ones. */
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 94 "lexer.ll"
{
                                    // Verbatim assembler text.
                                    // Copy contents of braces into yytext, and count newlines.
                                    // Update 'lineno' according to number of source lines taken.
                                    // Process cpp lines of the form '# <num> "<filename>"' if any.
                                    // 
                                    char *p;
                                    for (p = yytext + 3; *p != '{'; ++p)
                                        if (*p == '\n')
                                            ++lineno;

                                    char *begin = p + 1;
                                    char *end = strrchr(begin, '}');
                                    if (begin != end)  // only return something if text not empty
                                    {
                                        char *writer = yytext;
                                        bool lastCharIsNewline = true;
                                        for (char *reader = begin; reader != end; )
                                        {
                                            char c = *reader++;
                                            if (lastCharIsNewline && c == '#' && processPreprocessorLineDirective(reader))
                                            {
                                                lastCharIsNewline = true;
                                            }
                                            else
                                            {
                                                *writer++ = c;
                                                if (c == '\n')
                                                    ++lineno;
                                                lastCharIsNewline = (c == '\n');
                                            }
                                        }
                                        *writer = '\0';

                                        return VERBATIM_ASM;
                                    }
                                }
	YY_BREAK
/* White space: ignored. */
case 4:
YY_RULE_SETUP
#line 133 "lexer.ll"
;
	YY_BREAK
/* Newline increments the line counter. */
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 136 "lexer.ll"
{ lineno++; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 138 "lexer.ll"
{ return MINUS_MINUS; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 139 "lexer.ll"
{ return PLUS_PLUS; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 140 "lexer.ll"
{ return EQUALS_EQUALS; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 141 "lexer.ll"
{ return BANG_EQUALS; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 142 "lexer.ll"
{ return LOWER_EQUALS; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 143 "lexer.ll"
{ return GREATER_EQUALS; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 144 "lexer.ll"
{ return PLUS_EQUALS; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 145 "lexer.ll"
{ return MINUS_EQUALS; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 146 "lexer.ll"
{ return ASTERISK_EQUALS; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 147 "lexer.ll"
{ return SLASH_EQUALS; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 148 "lexer.ll"
{ return PERCENT_EQUALS; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 149 "lexer.ll"
{ return CARET_EQUALS; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 150 "lexer.ll"
{ return AMP_EQUALS; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 151 "lexer.ll"
{ return PIPE_EQUALS; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 152 "lexer.ll"
{ return AMP_AMP; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 153 "lexer.ll"
{ return PIPE_PIPE; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 154 "lexer.ll"
{ return LT_LT; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 155 "lexer.ll"
{ return GT_GT; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 156 "lexer.ll"
{ return LT_LT_EQUALS; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 157 "lexer.ll"
{ return GT_GT_EQUALS; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 158 "lexer.ll"
{ return RIGHT_ARROW; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 159 "lexer.ll"
{ return ELLIPSIS; }
	YY_BREAK
/* Hexadecimal constant. */
case 28:
YY_RULE_SETUP
#line 162 "lexer.ll"
{ unsigned long n;
                                   sscanf(yytext + 2, "%lx", &n);
                                   yylval.real = n;
                                   return REAL; }
	YY_BREAK
/* Binary constant. */
case 29:
YY_RULE_SETUP
#line 168 "lexer.ll"
{ unsigned long n = 0;
                            for (const char *p = yytext + 2; isdigit(*p); ++p)
                                n = (n << 1) | unsigned(*p != '0'); 
                            yylval.real = n;
                            return REAL; }
	YY_BREAK
/* Decimal float constant.
       No optional minus sign at the beginning of this rule, because it creates
       an ambiguity where 'n-1' is seen as tokens 'n' and '-1'. It should be seen
       as 'n', '-' and '1', and the add_expr rule in parser.yy will recognize
       these 3 tokens as a subtraction. 
    */
case 30:
YY_RULE_SETUP
#line 180 "lexer.ll"
{
                yylval.real = atof(yytext);
                warnIfDoublePrecisionLiteral(yytext);
                return REAL; }
	YY_BREAK
/* If there are no digits after the decimal point, there must be
       at least one digit before the point, e.g., "1.", "1.e6", "1.f", "1.e6f".
    */
case 31:
YY_RULE_SETUP
#line 188 "lexer.ll"
{
                yylval.real = atof(yytext);
                warnIfDoublePrecisionLiteral(yytext);
                return REAL; }
	YY_BREAK
/* Same as previous rule, but no decimal point, and required 'e'.
    */
case 32:
YY_RULE_SETUP
#line 195 "lexer.ll"
{
                yylval.real = atof(yytext);
                warnIfDoublePrecisionLiteral(yytext);
                return REAL; }
	YY_BREAK
/* Decimal or octal integer, with optional "unsigned" or "long" suffix character. */ 
case 33:
YY_RULE_SETUP
#line 201 "lexer.ll"
{
                uint64_t octalConversion = 0;
                if (yytext[0] == '0' && isOctal(octalConversion, yytext + 1))
                    yylval.real = double(octalConversion);
                else
                    yylval.real = atof(yytext);
                return REAL; }
	YY_BREAK
/* Keyword, typedef name or identifier. */
case 34:
YY_RULE_SETUP
#line 210 "lexer.ll"
{
                if (strcmp(yytext, "int") == 0) return INT;
                if (strcmp(yytext, "char") == 0) return CHAR;
                if (strcmp(yytext, "short") == 0) return SHORT;
                if (strcmp(yytext, "long") == 0) return LONG;
                if (strcmp(yytext, "float") == 0) return FLOAT;
                if (strcmp(yytext, "double") == 0) return DOUBLE;
                if (strcmp(yytext, "signed") == 0) return SIGNED;
                if (strcmp(yytext, "unsigned") == 0) return UNSIGNED;
                if (strcmp(yytext, "void") == 0) return VOID;
                if (strcmp(yytext, "if") == 0) return IF;
                if (strcmp(yytext, "else") == 0) return ELSE;
                if (strcmp(yytext, "while") == 0) return WHILE;
                if (strcmp(yytext, "do") == 0) return DO;
                if (strcmp(yytext, "for") == 0) return FOR;
                if (strcmp(yytext, "break") == 0) return BREAK;
                if (strcmp(yytext, "continue") == 0) return CONTINUE;
                if (strcmp(yytext, "return") == 0) return RETURN;
                if (strcmp(yytext, "asm") == 0) return ASM;
                if (strcmp(yytext, "__norts__") == 0) return NORTS;
                if (strcmp(yytext, "struct") == 0) return STRUCT;
                if (strcmp(yytext, "union") == 0) return UNION;
                if (strcmp(yytext, "interrupt") == 0) return INTERRUPT;
                if (strcmp(yytext, "__gcccall") == 0) return FUNC_USES_GCC6809_CALL_CONV;
                if (strcmp(yytext, "_CMOC_fpir_") == 0) return FUNC_RECEIVES_FIRST_PARAM_IN_REG;
                if (strcmp(yytext, "sizeof") == 0) return SIZEOF;
                if (strcmp(yytext, "typedef") == 0) return TYPEDEF;
                if (strcmp(yytext, "switch") == 0) return SWITCH;
                if (strcmp(yytext, "case") == 0) return CASE;
                if (strcmp(yytext, "default") == 0) return DEFAULT;
                if (strcmp(yytext, "asm") == 0) return ASM;
                if (strcmp(yytext, "register") == 0) return REGISTER;
                if (strcmp(yytext, "goto") == 0) return GOTO;
                if (strcmp(yytext, "extern") == 0) return EXTERN;
                if (strcmp(yytext, "static") == 0) return STATIC;
                if (strcmp(yytext, "enum") == 0) return ENUM;
                if (strcmp(yytext, "const") == 0) return CONST;
                if (strcmp(yytext, "volatile") == 0) return VOLATILE;
                if (strcmp(yytext, "auto") == 0) return AUTO;

                const TypeDesc *td = TranslationUnit::getTypeManager().getTypeDef(yytext);
                if (td)  // if yytext is the name of a typedef: 
                {
                    yylval.typeDesc = td;
                    return TYPE_NAME;
                }

                yylval.str = strdup(yytext); return ID;
                }
	YY_BREAK
/* Double-quoted string constant. No double-quote or newline allowed inside. */
case 35:
YY_RULE_SETUP
#line 261 "lexer.ll"
{ yylval.str = strdup(yytext + 1);
                        yylval.str[strlen(yylval.str) - 1] = '\0';
                        return STRLIT; }
	YY_BREAK
/* Control code character constants. */
case 36:
YY_RULE_SETUP
#line 266 "lexer.ll"
{ yylval.character = '\0'; return CHARLIT; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 267 "lexer.ll"
{ yylval.character = '\0'; return CHARLIT; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 268 "lexer.ll"
{ yylval.character = '\a'; return CHARLIT; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 269 "lexer.ll"
{ yylval.character = '\b'; return CHARLIT; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 270 "lexer.ll"
{ yylval.character = '\t'; return CHARLIT; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 271 "lexer.ll"
{ yylval.character = '\n'; return CHARLIT; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 272 "lexer.ll"
{ yylval.character = '\v'; return CHARLIT; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 273 "lexer.ll"
{ yylval.character = '\f'; return CHARLIT; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 274 "lexer.ll"
{ yylval.character = '\r'; return CHARLIT; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 275 "lexer.ll"
{ yylval.character = '\''; return CHARLIT; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 276 "lexer.ll"
{ yylval.character = '\"'; return CHARLIT; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 277 "lexer.ll"
{ yylval.character = '\\'; return CHARLIT; }
	YY_BREAK
/* Character constant expressed as a hexadecimal character code (e.g., '\xFF'). */
case 48:
YY_RULE_SETUP
#line 280 "lexer.ll"
{ unsigned int n;
                                sscanf(yytext + 3, "%x", &n);
                                yylval.character = (signed char) n;
                                return CHARLIT; }
	YY_BREAK
/* Character constant expressed as an octal character code (e.g., '\0377'). */
case 49:
YY_RULE_SETUP
#line 286 "lexer.ll"
{ unsigned int n;
                            sscanf(yytext + 2, "%o", &n);
                            yylval.character = (signed char) n;
                            return CHARLIT;}
	YY_BREAK
/* Other character constant. */
case 50:
YY_RULE_SETUP
#line 292 "lexer.ll"
{ yylval.character = yytext[1]; return CHARLIT; }
	YY_BREAK
/* Any non-blank single-character token. */
case 51:
YY_RULE_SETUP
#line 295 "lexer.ll"
{ return yytext[0]; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 297 "lexer.ll"
ECHO;
	YY_BREAK
#line 1362 "lexer.cc"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 152 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 152 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 151);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 297 "lexer.ll"



/*  Avoids warning about `yyunput' being defined but not used.
*/
void BlackHole(void) { yyunput('\0', NULL); }


/*  Returns true if 'str' contains only octal digits and puts the value in 'value'.
    Returns false otherwise; 'value' is then undefined.
*/
bool isOctal(uint64_t &value, const char *str)
{
    value = 0;
    for ( ; *str; ++str)
    {
        if (*str < '0' || *str > '7')  // if not octal digit
            return false;
        value = (value << 3) | (*str - '0');
    }
    return true;
}


// If reader points to ' <num> "<filename>"\n', then move reader past that
// and set global 'lineno' to <num>.
//
bool processPreprocessorLineDirective(char *&reader)
{
    char *r = reader;

    // Pass blanks.
    while (isspace(*r) && *r != '\n')
        ++r;

    // Try to parse a non-negative decimal int.
    char *endptr;
    unsigned long num = strtoul(r, &endptr, 10);
    if ((num == ULONG_MAX && errno) || num > INT_MAX)
        return false;
    r = endptr;

    // Pass blanks.
    while (isspace(*r) && *r != '\n')
        ++r;

    // Expect filename in double quotes.
    if (*r != '\"')
        return false;
    ++r;
    while (*r && *r != '\"')
        ++r;
    if (*r != '\"')
        return false;
    ++r;
    while (isspace(*r) && *r != '\n')
        ++r;
    if (*r != '\n')
        return false;

    // Found expected directive.
    reader = r + 1;
    ::lineno = (int) num;
    return true;
}

