/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_computeTrackAndSector(DECBFile *file,
                           byte fileGranIndex, byte sectorIndexInGranule,
                           byte *track, byte *sector)
{
    if (fileGranIndex >= DECB_MAX_NUM_GRANULES || sectorIndexInGranule >= 9)
        return DECB_ERR_INVALID_ARGUMENT;
    byte g;
    byte err = decb_getFileGranuleFromIndex(file, fileGranIndex, &g);
    if (err != DECB_OK)
        return err;
    // 'g' is now the granule that corresponds to 'fileGranIndex'.
    *track = g >> 1;
    if (g >= 34)  // if after dir track
        ++*track;
    *sector = sectorIndexInGranule + 1;
    if (g & 1)  // if 2nd granule of a track
        *sector += 9;
    //printf("COMPUTE: %u %u %u\n", g, *track, *sector);
    return DECB_OK;
}
