/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_copyFile(byte srcDriveNo, DECBDirEntry *srcDirEntry,
              byte destDriveNo, const char *destFilename,
              byte (*progressFunctor)(word currentSectorIndex,
                                      word totalNumSectors,
                                      void *userData),
              void *userData)
{
    DECBFile srcFile;
    byte err = decb_openSectorFileFromDirEntry(&srcFile, srcDriveNo, srcDirEntry);
    if (err != DECB_OK)
        return err;
    byte lastFileGranule;
    word numSectors;
    (void) decb_getNumGranulesInOpenFile(&srcFile, &lastFileGranule, &numSectors);
    DECBFile destFile;
    err = decb_createSectorFile(&destFile, destDriveNo, destFilename,
                                srcFile.fileType, srcFile.fileFormat);
    if (err != DECB_OK)
    {
        decb_closeSectorFile(&srcFile);
        return err;
    }
    for (word fileSectorIndex = 0; fileSectorIndex < numSectors; ++fileSectorIndex)
    {
        byte sectorBuffer[256];
        byte err = decb_readSector(&srcFile, sectorBuffer, fileSectorIndex);
        if (err == DECB_OK)
            err = decb_writeSector(&destFile, sectorBuffer, fileSectorIndex);
        if (err != DECB_OK)
        {
            decb_closeSectorFile(&srcFile);
            decb_closeSectorFile(&destFile);
            return err;
        }
        if (progressFunctor && !(*progressFunctor)(fileSectorIndex, numSectors, userData))
        {
            decb_closeSectorFile(&srcFile);
            decb_closeSectorFile(&destFile);
            return DECB_ERR_INTERRUPTED;
        }
    }
    decb_setNumBytesUsedInLastSector(&destFile, srcFile.numBytesUsedInLastSector);
    byte destErr = decb_closeSectorFile(&destFile);
    err = decb_closeSectorFile(&srcFile);
    if (destErr != DECB_OK)
        return destErr;
    return err;
}
