#include "crc16.h"


#if 0
uint16_t crc16_byte(uint16_t crc, uint8_t value)
{
    uint16_t x = (crc >> 8) ^ value;
    x ^= (x >> 4);
    return (crc << 8) ^ (x << 12) ^ (x << 5) ^ x;
}
#else
// CAUTION: This function must not change X.
//
asm uint16_t crc16_byte(uint16_t crc, uint8_t value)
{
    // crc: 2,s; value: 5,s
    asm
    {
        ldb     2,s     ; crc >> 8
        eorb    5,s     ; ^ value

        pshs    b
        lsrb            ; >> 4
        lsrb
        lsrb
        lsrb
        eorb    ,s      ; ^=

        stb     ,s      ; save 'x'
        clra            ; D = 'x'
        lslb            ; << 5
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola
        pshs    b,a     ; save x << 5
        lslb
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola
        lslb
        rola            ; D = (x << 12)
        eora    ,s+     ; D ^= (x << 5)
        eorb    ,s+
        eorb    ,s+     ; D ^= x

        eora    3,s     ; D ^= low byte of 'crc'
    }
}
#endif


uint16_t crc16_block(uint16_t crc, const void *block, unsigned int length)
{
    #if 0
    for (; length; --length)
        crc = crc16_byte(crc, *block++);
    #else
    uint8_t *end;
    asm
    {
        ldx     :block
        tfr     x,d
        addd    :length
        std     :end
        leas    -2,s    ; room for 2nd argument in calls to crc16_byte()
        ldd     :crc
        pshs    b,a     ; 1st argument
        ; ,s = running CRC value; 3,s = byte sent to crc16_byte().
        bra     @loopTest
@loopStart:
        ldb     ,x+     ; next byte in 'block'
        stb     3,s
        bsr     crc16_byte      ; CAUTION: this call must not change X
        std     ,s      ; for next call to crc16_byte()
@loopTest:
        cmpx    :end
        bne     @loopStart
        std     :crc    ; return value
        leas    4,s     ; get rid of call arguments
    }
    #endif
    return crc;
}
