/*  decbutil.c - Private functions to implement decbutil.h.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include <decbutil_private.h>

#include "dskcon-standalone.h"


word
decbutil_init(DECBDrive driveArray[1], byte driveNo, unsigned long *initReturnValue)
{
    *initReturnValue = dskcon_init(dskcon_nmiService);

    byte err = decb_init(driveArray, 1);
    if (err != DECB_OK)
        return STATUS(DECBUTIL_INIT, err);

    err = decb_setDskConAddresses(dskcon_processSector, (DECBDskConVariables *) &DCOPC);
    if (err != DECB_OK)
        return STATUS(DECBUTIL_SET_DSKCON_ADDRESSES, err);

    decb_registerDrive(driveNo);
    if (err != DECB_OK)
        return STATUS(DECBUTIL_REGISTER_DRIVE, err);

    return STATUS(DECBUTIL_NONE, DECB_OK);
}


word
decbutil_shutdown(unsigned long initReturnValue)
{
    byte err = decb_shutdown();
    if (err != DECB_OK)
        return STATUS(DECBUTIL_SHUTDOWN, err);

    dskcon_shutdown(initReturnValue);

    return STATUS(DECBUTIL_NONE, DECB_OK);
}


word
decbutil_closeAndShutdown(DECBFile *file, unsigned long initReturnValue)
{
    byte err = decb_closeSectorFile(file);
    if (err != DECB_OK)
        return STATUS(DECBUTIL_CLOSE_SECTOR_FILE, err);

    return decbutil_shutdown(initReturnValue);
}
