/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_dskcon(byte operation, void *buffer, byte drive, byte track, byte sector)
{
    //printf("DSKCON(%u, %p, %u, %u, %u)\n", operation, buffer, drive, track, sector);
    if (operation != DECB_DSKCON_READ && operation != DECB_DSKCON_WRITE)
        return FALSE;
    if (drive >= 4)
        return FALSE;
    if (track >= DECB_MAX_NUM_TRACKS)
        return FALSE;
    if (sector == 0)
        return FALSE;
    if (sector > 18)
        return FALSE;
    // Fill DSKCON input variables.
    decb_dskcon_variables->opCode = operation;
    decb_dskcon_variables->drive  = drive;    
    decb_dskcon_variables->track  = track;    
    decb_dskcon_variables->sector = sector;   
    decb_dskcon_variables->buffer = buffer;   
    asm
    {
        pshs    u,y,x,a                 // protect against BASIC routine
        jsr     [decb_dskcon_routine]   // call DSKCON
        puls    a,x,y,u
    }
    return decb_dskcon_variables->status == 0;
}
