/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_findDirEntry(byte forNewFile,
                  byte driveNo,
                  char normalizedFilename[12],
                  byte dirSectorBuffer[256],
                  byte *dirSectorNum,
                  byte *byteOffsetInDirSector)
{
    byte firstEmptyEntrySectorNum = DECB_LAST_DIR_SECTOR + 1;
    byte firstEmptyEntryOffset = 255;  // if entry found, this will be multiple of 32
    byte sector;
    for (sector = 3; sector <= DECB_LAST_DIR_SECTOR; ++sector)
    {
        if (!decb_dskcon(DECB_DSKCON_READ, dirSectorBuffer, driveNo, 17, sector))
        {
            return DECB_ERR_IO;
        }
        DECBDirEntry *entry;
        for (word index = 0; index < 256; index += 32)
        {
            entry = (DECBDirEntry *) (dirSectorBuffer + index);
            if (entry->name[0] == 0)  // if erased entry
            {
                if (forNewFile && firstEmptyEntryOffset == 255)  // if 1st empty entry found
                {
                    firstEmptyEntrySectorNum = sector;
                    firstEmptyEntryOffset = (byte) index;
                }
                continue;
            }
            if ((byte) entry->name[0] == 0xFF)  // if end of dir
            {
                if (forNewFile && firstEmptyEntryOffset == 255)  // if 1st empty entry found
                {
                    firstEmptyEntrySectorNum = sector;
                    firstEmptyEntryOffset = (byte) index;
                }
                break;
            }
            if (memcmp(entry, normalizedFilename, 11) == 0)  // if filename matches
            {
                if (forNewFile)
                    return DECB_ERR_ALREADY_EXISTS;
                *dirSectorNum = sector;
                *byteOffsetInDirSector = (byte) index;
                return DECB_OK;  // found
            }
        }
        if ((byte) entry->name[0] == 0xFF)  // if end of dir
            break;
    }
    if (firstEmptyEntryOffset != 255)  // implies forNewFile
    {
        *dirSectorNum = firstEmptyEntrySectorNum;
        *byteOffsetInDirSector = firstEmptyEntryOffset;
        // Reload the sector of the new entry, if it is not
        // the last sector read.
        if (firstEmptyEntrySectorNum != sector)
        {
            if (!decb_dskcon(DECB_DSKCON_READ, dirSectorBuffer,
                             driveNo, 17, firstEmptyEntrySectorNum))
                return DECB_ERR_IO;
        }
        return DECB_OK;
    }
    return DECB_ERR_NOT_FOUND;
}
