/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_findFreeGranule(byte driveNo)
{
    byte err = decb_readFAT(driveNo);
    if (err != DECB_OK)
        return 0xFF;
    const DECBDrive *drv = decb_getDrive(driveNo);
    if (!drv)
        return 0xFF;
    const byte *fat = drv->fatBuffer;
    for (byte g = 0; g < DECB_MAX_NUM_GRANULES; ++g)
        if (fat[g] == 0xFF)
            return g;
    return 0xFF;
}
