/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_flush(DECBFile *file, DECBSeqWriteBuffer *writeBuffer)
{
    byte *buf = writeBuffer->buffer;
    word used = writeBuffer->numUsedBytes;
    byte err = decb_writeSector(file, buf, writeBuffer->numSectorsWritten);
    if (err != DECB_OK)
        return err;
    // Move any remaining bytes to beginning of buffer.
    if (used > 256)
    {
        used -= 256;
        memcpy(buf, buf + 256, used);
    }
    else
        used = 0;
    writeBuffer->numUsedBytes = used;
    ++writeBuffer->numSectorsWritten;
    return DECB_OK;
}
