/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_getFileGranuleFromIndex(DECBFile *file,
                             byte fileGranIndex,
                             byte *fatEntryIndex)
{
    byte g = file->firstGranule;  // this is an index into the FAT
    if (g >= DECB_MAX_NUM_GRANULES)
        return DECB_ERR_CORRUPT_DIR;
    byte err = decb_readFAT(file->driveNo);
    if (err != DECB_OK)
        return err;
    const DECBDrive *drv = decb_getDrive(file->driveNo);
    if (!drv)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    const byte *fat = drv->fatBuffer;
    for (byte gi = fileGranIndex; gi != 0; --gi)
    {
        g = fat[g];
        if (! decb_isValidFATEntry(g))
            return DECB_ERR_CORRUPT_FAT;
        if (g >= 0xC1)
            return DECB_ERR_INVALID_ARGUMENT;  // fileGranIndex too large for file
    }
    *fatEntryIndex = g;
    return DECB_OK;
}
