/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_getFileSizeFromFilename(byte driveNo, const char *filename,
                             word *numSectors, dword *lengthInBytes)
{
    byte dirSectorBuffer[256];
    byte dirSectorNum;
    DECBDirEntry *dirEntry;
    byte err = decb_getDirEntryFromUnnormalizedFilename(driveNo, filename,
                                dirSectorBuffer, &dirSectorNum, &dirEntry);
    if (err != DECB_OK)
        return 0xFF;
    return decb_getFileSizeFromDirEntry(driveNo, dirEntry, numSectors, lengthInBytes);
}
