/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_getNumFreeGranules(byte driveNo, byte *numFreeGranules)
{
    *numFreeGranules = 0;
    byte err = decb_readFAT(driveNo);
    if (err != DECB_OK)
        return err;
    const DECBDrive *drv = decb_getDrive(driveNo);
    if (!drv)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    const byte *fat = drv->fatBuffer;
    for (byte i = 0; i < DECB_MAX_NUM_GRANULES; ++i)
        if (fat[i] == 0xFF)
            ++*numFreeGranules;
    return DECB_OK;
}
