/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


// Private function.
// Determines the file-relative sector index where the record at 'recordIndex' would start.
//
// recordIndex: From 0 to 65534 (sic) inclusively. Index 65535 is disallowed.
//
byte
decb_getRecordOffsets(DECBRecordFile *recFile, word recordIndex,
                      word *sectorIndex, byte *byteOffsetInSector)
{
    if (recordIndex == 0xFFFF)
        return DECB_ERR_INVALID_ARGUMENT;  // disallowed: recFile->numRecords cannot be 0x10000
    // sectorIndex = (recFile->headerSize + recordIndex * recFile->recordSize) / 256.
    //
    dword size = (dword) recordIndex * recFile->recordSize + recFile->headerSize;
    if (size > 0xFFFFFFUL)  // if byte offset > 24 bits
        return DECB_ERR_INVALID_ARGUMENT;
    *byteOffsetInSector = (byte) (size & 0xFF);
    *sectorIndex = (word) (size >> 8);
    return DECB_OK;
}
