/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


void
decb_normalizeFilename(char dest[12], const char *src)
{
    const char *reader = src;
    byte i;
    for (i = 0; i < 8; ++i)  // copy filename until period
    {
        if (*reader == '.')
        {
            ++reader;  // skip the point: it is not part of the extension
            break;
        }
        if (*reader == 0)
            break;
        *dest = (char) toupper(*reader);
        ++dest;
        ++reader;
    }
    if (i == 8)  // if filename is at least 8 chars long
    {
        // Check if filename too long.
        while (*reader != 0 && *reader != '.')
            ++reader;
        if (*reader == '.')  // skip the point
            ++reader;
    }
    else
        while (i < 8)  // pad filename with spaces
        {
            *dest++ = ' ';
            ++i;
        }
    for (i = 0; i < 3; ++i)  // copy extension
    {
        if (*reader == 0)
            break;
        *dest = (char) toupper(*reader);
        ++reader;
        ++dest;
    }
    while (i < 3)  // pad extension with spaces
    {
        *dest++ = ' ';
        ++i;
    }
    *dest = '\0';
}
