/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_readDir(DECBDirIterator *dirIter, DECBDirEntry **dirEntry)
{
    for (;;)
    {
        if (dirIter->entryOffset == 0)  // if at start of sector of dir, read sector:
        {
            if (dirIter->sectorIndex > DECB_LAST_DIR_SECTOR)
                return DECB_ERR_END_OF_DIR;
            if (!decb_dskcon(DECB_DSKCON_READ, dirIter->sectorBuffer, dirIter->driveNo, 17, dirIter->sectorIndex))
                return DECB_ERR_IO;
            ++dirIter->sectorIndex;
        }
        DECBDirEntry *entry = (DECBDirEntry *) (dirIter->sectorBuffer + dirIter->entryOffset);
        dirIter->entryOffset += 32;
        byte firstNameByte = (byte) entry->name[0];
        if (firstNameByte == 0)  // if erased entry
            continue;
        if (firstNameByte == 0xFF)
            return DECB_ERR_END_OF_DIR;
        *dirEntry = entry;
        return DECB_OK;
    }
}
