/*  readFileToMemory.c

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include "decbutil.h"

#include "decbutil_private.h"


struct BufferSpec
{
    void *memory;
    size_t numSectors;
};


static void *
returnBufferSpec(size_t *numSectors, unsigned long fileSizeInBytes, void *userData)
{
    struct BufferSpec *spec = (struct BufferSpec *) userData;
    if (spec->numSectors < *numSectors)  // if the client wants to load fewer sectors than are in the file
        *numSectors = spec->numSectors;  // tell decbutil_readFileToDynamicMemory() to load fewer sectors
    return spec->memory;
}


word
decbutil_readFileToMemory(byte driveNo, const char *filename,
                          void *memory, size_t numSectors)
{
    struct BufferSpec spec = { memory, numSectors };
    return decbutil_readFileToDynamicMemory(driveNo, filename, returnBufferSpec, &spec);
}
