/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_readHeader(DECBRecordFile *recFile, byte *header)
{
    if (recFile->headerSize == 0)
        return DECB_OK;
    // The header may span more than one sector.
    // The last of these sectors may only be partially occupied by the header.
    byte numHeaderSectors = (byte) ((recFile->headerSize + 255) >> 8);
    byte lastHeaderSectorIndex = numHeaderSectors - 1;
    for (byte sectorIndex = 0; sectorIndex < lastHeaderSectorIndex; ++sectorIndex)  // for each complete sector
    {
        byte err = decb_readSector(&recFile->file, header + (((word) sectorIndex) << 8), sectorIndex);
        if (err != DECB_OK)
            return err;
    }
    // Read the header's last sector.
    // Copy only part of it (or all of it, if the header size is divisible by the sector size).
    byte sectorBuffer[256];
    byte err = decb_readSector(&recFile->file, sectorBuffer, lastHeaderSectorIndex);
    if (err != DECB_OK)
        return err;
    word memcpySize = recFile->headerSize & 0x00FF;
    if (memcpySize == 0)
        memcpySize = 256;
    memcpy(header + (((word) lastHeaderSectorIndex) << 8), sectorBuffer, memcpySize);
    return DECB_OK;
}
