/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_truncateOpenFile(DECBFile *file,
                      word newNumSectors,
                      word numBytesUsedInLastSector)
{
    if (newNumSectors == 0)  // special case: no bytes used in "last" sector
        return decb_truncateOpenFileInGranules(file, 0, 1, 0);
    word numGranulesWithSuccessor = (newNumSectors - 1) / 9;
    if (numGranulesWithSuccessor > DECB_MAX_NUM_GRANULES - 1)  // past EOF?
        return DECB_OK;
    byte numSectorsInLastGranule = (byte) (newNumSectors % 9);
    if (numSectorsInLastGranule == 0)
        numSectorsInLastGranule = 9;
    return decb_truncateOpenFileInGranules(file,
                                 (byte) numGranulesWithSuccessor,
                                 numSectorsInLastGranule,
                                 numBytesUsedInLastSector);
}
