/*  utread.c - Demo of decbutil_readFileToMemory (decbutil.h).

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include "decbutil.h"


int
main()
{
    initCoCoSupport();
    setHighSpeed(FALSE);
    rgb();
    width(32);
    cls(255);
    
    // Load a 32x16 screen from a file.
    const char *filename = "SCREEN.DAT";
    byte driveNo = 0;
    printf("LOADING %s:%u...\n", filename, driveNo);

    // Read a 512-byte 32x16 screen from a file to address 1024. That is 2 sectors.
    word code = decbutil_readFileToMemory(driveNo, filename, (void *) 1024, 2);
    byte err = DECBUTIL_ERR(code);
    if (err != DECB_OK)
    {
        locate(0, 13);
        printf("ERROR #%u AT STEP #%u\n", err, DECBUTIL_STEP(code));
        return 1;
    }

    locate(10, 11);
    printf("PRESS A KEY.");
    waitkey(FALSE);

    locate(0, 13);
    printf("SUCCESS.\n");
    return 0;
}
