/*  utwrite.c - Demo of decbutil_writeMemoryToFile (decbutil.h).

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include "decbutil.h"


int
main()
{
    initCoCoSupport();
    setHighSpeed(FALSE);
    rgb();
    width(32);
    cls(3);  // blue
    
    // Draw a 32x16 screen to be saved to a file.
    const char *filename = "SCREEN.DAT";
    byte driveNo = 0;

    byte borderChar = 0xBF;  // red block
    memset(1024, borderChar, 32);
    memset(1024 + 15 * (word) 32, borderChar, 32);
    for (byte row = 1; row < 15; ++row)
    {
        byte *p = (byte *) (1024 + (word) row * 32);
        p[0]  = borderChar;
        p[31] = borderChar;
    }

    locate(2, 7);
    printf("SCREEN SAVED TO %s:%u", filename, driveNo);

    // Write the 512-byte 32x16 screen at address 1024 to a file. That is 2 sectors.
    word code = decbutil_writeMemoryToFile(driveNo, filename, (void *) 1024, 2, FALSE);
    byte err = DECBUTIL_ERR(code);

    if (err != DECB_OK)
    {
        locate(0, 13);
        printf("ERROR #%u AT STEP #%u\n", err, DECBUTIL_STEP(code));
        return 1;
    }

    locate(10, 11);
    printf("PRESS A KEY.");
    waitkey(FALSE);

    locate(0, 13);
    printf("SUCCESS.\n");
    return 0;
}
