/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_closeSectorFile(DECBFile *file)
{
    if (!file || file->dirSectorNum < 3)
        return DECB_ERR_INVALID_ARGUMENT;
    if (file->modified)  // if file was modified
    {
        byte err = decb_writeFAT(file->driveNo);
        if (err != DECB_OK)
            return err;
        byte dirSectorBuffer[256];
        if (!decb_dskcon(DECB_DSKCON_READ, dirSectorBuffer, file->driveNo, 17, file->dirSectorNum))
            return DECB_ERR_IO;
        DECBDirEntry *entry = (DECBDirEntry *) (dirSectorBuffer + file->byteOffsetInDirSector);
        word last = file->numBytesUsedInLastSector;
        entry->numBytesUsedInLastSector = (last == 0 ? 256u : last);
        if (!decb_dskcon(DECB_DSKCON_WRITE, dirSectorBuffer, file->driveNo, 17, file->dirSectorNum))
            return DECB_ERR_IO;
    }
    file->dirSectorNum = 1;  // mark this file object as closed
    return DECB_OK;
}
