/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_createRecordFile(DECBRecordFile *recFile, byte driveNo, const char *filename,
                      word headerSize, word recordSize)
{
    if (recordSize == 0)
        return DECB_ERR_INVALID_ARGUMENT;
    byte err = decb_createSectorFile(&recFile->file, driveNo, filename,
                                     DECB_TYPE_BASIC_DATA, DECB_FORMAT_BINARY);
    if (err != DECB_OK)
        return err;
    recFile->headerSize = headerSize;
    recFile->recordSize = recordSize;
    recFile->numRecords = 0;
    return DECB_OK;
}
