/*  decbdrivewire.h

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#ifndef _decbdrivewire_h_
#define _decbdrivewire_h_

#include <decbfile.h>


// Returns 0 on success, or an error code otherwise.
// dest: Must not be null.
// numBytes: Allowed to be zero.
//
typedef byte (*DWReadFuncPtr)(void *dest, word numBytes);


// Returns 0 on success, or an error code otherwise.
// dest: Must not be null.
// numBytes: Allowed to be zero.
//
typedef byte (*DWWriteFuncPtr)(const void *dest, word numBytes);


// To be called after decb_registerDrive().
// dwReadFuncPtr: Pointer to a function that reads a sequence of bytes
//                from the DriveWire server.
//                Use dwReadBeckerPort to read from the Becker port.
// dwWriteFuncPtr: Pointer to a function that writes a sequence of bytes
//                 to the DriveWire server.
//                Use dwWriteBeckerPort to write from the Becker port.
//
void decb_initDriveWireSupport(DWReadFuncPtr dwReadFuncPtr,
                               DWWriteFuncPtr dwWriteFuncPtr);


// Reads a sequence of bytes from the Becker port.
// Returns 0 on success, or an error code otherwise.
//
byte dwReadBeckerPort(void *dest, word numBytes);


// Writes a sequence of bytes to the Becker port.
// Returns 0 on success, or an error code otherwise.
//
byte dwWriteBeckerPort(const void *dest, word numBytes);


#endif  /* _decbdrivewire_h_ */
