/*  decbfile_private.h

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#ifndef _H_decbfile_private_
#define _H_decbfile_private_


#include "decbfile.h"


#define BECKER_PORT_STATUS (* (unsigned char *) 0xFF41)  /* Bit 1 is set when data ready */
#define BECKER_PORT_DATA   (* (unsigned char *) 0xFF42)


extern word decb_numRegisteredDrives;
extern word decb_driveArrayCapacity;
extern DECBDrive *decb_drives;
extern void (*decb_dskcon_routine)(void);
extern DECBDskConVariables *decb_dskcon_variables;


DECBDrive *
decb_getDrive(byte decbDriveNo);


byte
decb_getRecordOffsets(DECBRecordFile *recFile, word recordIndex,
                      word *sectorIndex, byte *byteOffsetInSector);

byte
decb_truncateOpenFileInGranules(DECBFile *file,
                                byte numGranulesWithSuccessor,
                                byte numSectorsInLastGranule,
                                word numBytesUsedInLastSector);

byte
decb_getDirEntryFromUnnormalizedFilename(byte driveNo, const char *filename,
                                         byte dirSectorBuffer[256],
                                         byte *dirSectorNum,
                                         DECBDirEntry **dirEntry);

byte
decb_getNumGranulesInFile(byte driveNo, byte firstGranule,
                          byte *lastFileGranule, word *numSectors);


#endif  /* _H_decbfile_private_ */
