/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


void
decb_denormalizeFilename(char dest[13], char src[11], byte lowerCase)
{
    memcpy(dest, src, 8);
    byte i;
    for (i = 8; i--; )
        if (dest[i] != ' ')
            break;
    // i is now 0xFF (if src[] is entirely spaces)
    // or it designates the last non-space char in src[].
    // Advance i to point past the last non-space char.
    // Put the extension point there.
    dest[++i] = '.';
    memcpy(dest + i + 1, src + 8, 3);
    for (i += 4; i--; )
        if (dest[i] != ' ')
            break;
    dest[++i] = '\0';
    if (lowerCase)
        for (i = 0; dest[i]; ++i)
            dest[i] = (char) tolower(dest[i]);
}
