/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_freeGranuleChain(byte driveNo, byte firstGranule)
{
    if (firstGranule >= DECB_MAX_NUM_GRANULES)
        return DECB_ERR_INVALID_ARGUMENT;
    byte err = decb_readFAT(driveNo);
    if (err != DECB_OK)
        return err;
    DECBDrive *drv = decb_getDrive(driveNo);
    if (!drv)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    byte *fat = drv->fatBuffer;
    byte g = firstGranule;
    while (g < 0xC0)  // while 'g' points to a successor FAT entry index
    {
        byte next = fat[g];
        byte err = decb_setFATEntry(driveNo, g, 0xFF);
        if (err != DECB_OK)
            return err;
        g = next;
        if (!decb_isValidFATEntry(g))
            return DECB_ERR_CORRUPT_FAT;
    }
    return DECB_OK;
}
