/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


// Private function.
//
byte
decb_getDirEntryFromUnnormalizedFilename(byte driveNo, const char *filename,
                                         byte dirSectorBuffer[256],
                                         byte *dirSectorNum,
                                         DECBDirEntry **dirEntry)
{
    char normalizedFilename[12];
    decb_normalizeFilename(normalizedFilename, filename);
    byte byteOffsetInDirSector;
    byte err = decb_findDirEntry(FALSE, driveNo, normalizedFilename,
                                 dirSectorBuffer, dirSectorNum, &byteOffsetInDirSector);
    if (err != DECB_OK)
    {
        *dirEntry = 0;
        return err;
    }
    *dirEntry = (DECBDirEntry *) (dirSectorBuffer + byteOffsetInDirSector);
    return DECB_OK;
}
