/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_getFileSizeFromDirEntry(byte driveNo, DECBDirEntry *entry,
                             word *numSectors, dword *lengthInBytes)
{
    byte lastFileGranule;  // will be ignored
    byte numGrans = decb_getNumGranulesInFile(driveNo, entry->firstGranule,
                                              &lastFileGranule, numSectors);
    if (numGrans == 0xFF)
        return 0xFF;
    *lengthInBytes = ((dword) (*numSectors - 1) << 8) + entry->numBytesUsedInLastSector;
    return numGrans;
}
