/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


// Private function.
//
byte
decb_getNumGranulesInFile(byte driveNo, byte firstGranule,
                          byte *lastFileGranule, word *numSectors)
{
    byte g = firstGranule;
    if (g >= DECB_MAX_NUM_GRANULES)
        return 0xFF;
    byte err = decb_readFAT(driveNo);
    if (err != DECB_OK)
        return 0xFF;
    DECBDrive *drv = decb_getDrive(driveNo);
    if (!drv)
        return 0xFF;
    byte *fat = drv->fatBuffer;
    word s = 0;  // sector counter
    for (byte n = 1; ; )
    {
        *lastFileGranule = g;
        g = fat[g];
        if (! decb_isValidFATEntry(g))
            return 0xFF;
        if (g >= 0xC1)
        {
            *numSectors = s + (g & 0x0F);
            return n;
        }
        ++n;
        s += 9;
    }
}
