/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_getOpenFileSize(DECBFile *file, word *numSectors, dword *lengthInBytes)
{
    byte lastFileGranule;  // will be ignored
    byte numGrans = decb_getNumGranulesInOpenFile(file, &lastFileGranule, numSectors);
    if (numGrans == 0xFF)
        return 0xFF;
    *lengthInBytes = ((dword) (*numSectors - 1) << 8) + file->numBytesUsedInLastSector;
    return numGrans;
}
