/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


word decb_numRegisteredDrives;
word decb_driveArrayCapacity;
DECBDrive *decb_drives;  // order of elements is not significant
void (*decb_dskcon_routine)(void);
DECBDskConVariables *decb_dskcon_variables;


typedef void (*DskConRoutine)(void);


byte
decb_init(DECBDrive *driveArray, word numDrives)
{
    decb_setDskConAddresses(* (DskConRoutine *) 0xC004,
                            * (DECBDskConVariables **) 0xC006);
    decb_numRegisteredDrives = 0;
    decb_driveArrayCapacity = numDrives;
    decb_drives = driveArray;
    return DECB_OK;
}


byte
decb_registerDrive(byte decbDriveNo)
{
    if (decb_numRegisteredDrives >= decb_driveArrayCapacity)
        return DECB_ERR_OUT_OF_SPACE;
    if (decb_getDrive(decbDriveNo) != NULL)
        return DECB_ERR_ALREADY_EXISTS;
    DECBDrive *drv = &decb_drives[decb_numRegisteredDrives];
    ++decb_numRegisteredDrives;
    drv->driveNo = decbDriveNo;
    drv->fatLoaded = FALSE;
    drv->fatNeedsSave = FALSE;
    return DECB_OK;
}


DECBDrive *
decb_getDrive(byte decbDriveNo)
{
    for (word i = 0; i < decb_numRegisteredDrives; ++i)
        if (decb_drives[i].driveNo == decbDriveNo)
            return &decb_drives[i];
    return NULL;
}
