/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_kill(byte driveNo, const char *filename)
{
    byte dirSectorBuffer[256];
    byte dirSectorNum;
    DECBDirEntry *dirEntry;
    byte err = decb_getDirEntryFromUnnormalizedFilename(driveNo, filename,
                                dirSectorBuffer, &dirSectorNum, &dirEntry);
    if (err != DECB_OK)
        return err;
    dirEntry->name[0] = 0;
    if (!decb_dskcon(DECB_DSKCON_WRITE, dirSectorBuffer, driveNo, 17, dirSectorNum))
        return DECB_ERR_IO;
    err = decb_freeGranuleChain(driveNo, dirEntry->firstGranule);
    if (err != DECB_OK)
        return err;
    return decb_writeFAT(driveNo);
}
