/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_openRecordFile(DECBRecordFile *recFile, byte driveNo, const char *filename,
                    word headerSize, word recordSize)
{
    if (recordSize == 0)
        return DECB_ERR_INVALID_ARGUMENT;
    byte err = decb_openSectorFile(&recFile->file, driveNo, filename);
    if (err != DECB_OK)
        return err;
    recFile->headerSize = headerSize;
    recFile->recordSize = recordSize;
    // Compute and store the number of records in the file.
    // Get the file length in bytes, subtract header size, then divide by recordSize.
    //
    word numSectors;
    dword size;
    if (decb_getOpenFileSize(&recFile->file, &numSectors, &size) == 0xFF)
        return DECB_ERR_CORRUPT_FAT;
    size -= headerSize;
    size += recordSize - 1;  // round up the number of records, if last record incomplete
    size /= recordSize;
    if (size > 0xFFFF)
        return DECB_ERR_INVALID_ARGUMENT;  // too many records to represent index in 16 bits
    recFile->numRecords = (word) (size & 0xFFFF);
    return DECB_OK;
}
