/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_openSectorFile(DECBFile *file, byte driveNo, const char *filename)
{
    // Normalize the filename to 8+3 form.
    //
    char normalizedFilename[12];
    decb_normalizeFilename(normalizedFilename, filename);
    // Find the dir entry.
    //
    byte dirSectorBuffer[256];
    byte dirSectorNum, byteOffsetInDirSector;
    byte err = decb_findDirEntry(FALSE, driveNo, normalizedFilename, dirSectorBuffer,
                                 &dirSectorNum, &byteOffsetInDirSector);
    if (err != DECB_OK)
        return err;
    // Initialize the DECBFile structure.
    //
    file->driveNo = driveNo;
    file->dirSectorNum = dirSectorNum;
    file->byteOffsetInDirSector = byteOffsetInDirSector;
    DECBDirEntry *dirEntry = (DECBDirEntry *) (dirSectorBuffer + byteOffsetInDirSector);
    file->fileType = dirEntry->fileType;
    file->fileFormat = dirEntry->fileFormat;
    file->numBytesUsedInLastSector = dirEntry->numBytesUsedInLastSector;
    file->firstGranule = dirEntry->firstGranule;
    file->modified = FALSE;
    return DECB_OK;
}
