/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_readFAT(byte driveNo)
{
    DECBDrive *drive = decb_getDrive(driveNo);
    if (!drive)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    if (drive->fatLoaded)
        return DECB_OK;
    char sectorBuffer[256];
    if (!decb_dskcon(DECB_DSKCON_READ, sectorBuffer, driveNo, 17, 2))
        return DECB_ERR_IO;
    memcpy(drive->fatBuffer, sectorBuffer, DECB_MAX_NUM_GRANULES);
    drive->fatLoaded = TRUE;
    return DECB_OK;
}
